package com.bxm.fossicker.commodity.model.constant;

import com.bxm.newidea.component.redis.KeyGenerator;
import com.bxm.newidea.component.redis.impl.DefaultKeyGenerator;

/**
 * @author Gonzo
 * @date 2019-09-28 11:36
 */
public class CommodityRedisKey {

    private static final KeyGenerator COMMODITY_INFO_BASE_KEY = DefaultKeyGenerator.build("commodity", "cache");

    /**
     * 淘宝爬取商品缓存key
     * 需要加一级key 避免单个key数据过多
     * CommodityInfoRedisKeyConstant.TAOBAO_COMMODITY_INFO.copy(Math.abs(commodityId.hashCode()) % 10)
     */
    public static final KeyGenerator TAOBAO_COMMODITY_INFO = COMMODITY_INFO_BASE_KEY.copy().setKey("taobaoCommodityInfo");


    /**
     * 缓存标签信息
     */
    public static final KeyGenerator GOODS_LABEL_TYPE = COMMODITY_INFO_BASE_KEY.copy().setKey("label");


    /**
     * vip 0元购购买数据key（跑马灯数据）
     */
    public static final KeyGenerator VIP_ZERO_COMMODITY_PURCHASE_INFOS = COMMODITY_INFO_BASE_KEY.copy()
            .setKey("vipZeroCommodityPurchaseInfos");
}
