package com.bxm.fossicker.commodity.model.constant;

/**
 * @Description: 商品下架备注
 * @author: yangxin
 * @date: 2019/12/26  10:51
 */
public enum LowershelfSignEnum {
    /**
     * 商品价格变动下架
     */
    COMMODITY_PRICE_CHANGE((byte) 1, "商品价格变动下架"),
    COMMODITY_INVALID_LOWERSHELF((byte) 2, "商品失效下架"),
    COMMODITY_TIMER_LOWERSHELF((byte) 3, "商品定时下架"),
    COMMODITY_MANUAL_LOWERSHELF((byte) 4, "商品手动下架");

    private byte type;
    private String des;

    LowershelfSignEnum(byte type, String des) {
        this.type = type;
        this.des = des;
    }

    public static String getDes(Integer type) {
        LowershelfSignEnum[] enums = LowershelfSignEnum.values();
        for (LowershelfSignEnum signEnum : enums) {
            if (signEnum.getType() == type) {
                return signEnum.getDes();
            }
        }

        return "";
    }

    public byte getType() {
        return type;
    }

    public void setType(byte type) {
        this.type = type;
    }

    public String getDes() {
        return des;
    }

    public void setDes(String des) {
        this.des = des;
    }
}

