package com.bxm.fossicker.commodity.model.dto;


import com.bxm.fossicker.constant.LocalCommoditySourceFrom;
import com.fasterxml.jackson.annotation.JsonIgnore;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Builder;
import lombok.Data;
import lombok.experimental.Tolerate;

import java.util.List;

@Data
@Builder
@ApiModel("商品详情DTO")
/**
 * 商品详情DTO
 * @author Dong_hy
 */
public class CommodityDetailDTO {

    @Tolerate
    public CommodityDetailDTO() {
    }

    /**
     * 商品id
     */
    @ApiModelProperty(value = "商品id")
    private Long goodsId;

    /**
     * 商品标题
     */
    @ApiModelProperty(value = "商品标题")
    private String commodityTitle;

    /**
     * 商品图片list
     */
    @ApiModelProperty(value = "商品图片list")
    private List<String> imgUrlList;

    /**
     * 销量
     */
    @ApiModelProperty(value = "销量")
    private Integer salesNum;

    /**
     * 店铺名称
     */
    @ApiModelProperty(value = "店铺名称")
    private String shopName;

    /**
     * 店铺标志
     */
    @ApiModelProperty(value = "店铺标志")
    private String shopIcon;

    /**
     * 店铺链接url
     */
    @ApiModelProperty(value = "店铺链接url")
    private String shopUrl;

    @ApiModelProperty(value = " 店铺类型，1-天猫，0-淘宝")
    private Integer shopType;

    /**
     * 商品描述得分
     */
    @ApiModelProperty(value = "商品描述得分")
    private String commodityScore;

    /**
     * 卖家服务得分
     */
    @ApiModelProperty(value = "卖家服务得分")
    private String sellerScore;

    /**
     * 物流得分
     */
    @ApiModelProperty(value = "物流得分")
    private String logisticsScore;

    /**
     * 收藏状态,0:未收藏,1:已收藏
     */
    @ApiModelProperty(value = "收藏状态,0:未收藏,1:已收藏")
    private Integer collectStatus;

    /**
     * 分享赚的钱
     */
    @ApiModelProperty(value = "分享赚的钱")
    private Double shareMoney;

    @ApiModelProperty(value = "商品原价")
    private Double reservePrice;

    @ApiModelProperty(value = "商品价格-到手价,商品原价-优惠券价格-佣金")
    private Double commodityPrice;

    @ApiModelProperty(value = "券后价,商品原价-优惠券价格")
    private Double discountPrice;

    @ApiModelProperty(value = "优惠券价格")
    private Double couponPrice;

    @ApiModelProperty(value = "最终的佣金值", notes = "可能是普通佣金，也可能是vip佣金 也可能是0元购的佣金等")
    private Double commissionPrice;

    /**
     * 平台佣金值 = 商品券后价 * 三方给我们平台的佣金比例
     * 改字段不返回，仅作计算用
     * json 序列化时会忽略
     */
    @ApiModelProperty(value = "平台佣金值", hidden = true)
    @JsonIgnore
    private Double platformCommissionPrice;

    /**
     * 普通佣金值 = 商品券后价 * 三方给我们平台的佣金比例 * 我们平台给用户的佣金比例
     * 当商品不为任何其他特殊情况时的普通佣金值
     */
    @ApiModelProperty(value = "普通佣金值")
    private Double normalCommissionPrice;

    @ApiModelProperty(value = "优惠券链接")
    private String couponUrl;

    @ApiModelProperty(value = "惠好省金币可领状态,0:不可领,1:可领")
    private Integer goldStatus;

    @ApiModelProperty(value = "惠好省金币数量")
    private Integer goldNum;

    @ApiModelProperty(value = "商品主图", hidden = true)
    private String mainPic;

    @ApiModelProperty(value = "商品提醒状态:1-已设置提醒,0-未设置提醒")
    private Integer remindStatus;

    @ApiModelProperty(value = "推荐内容")
    private String recommendContent;

    @ApiModelProperty(value = "有效状态,0-失效,1-有效")
    private Integer validStatus = 1;

    @ApiModelProperty(value = "是否新人专享  true:是  false:否 （新人专享商品 && 新人）")
    private Boolean newbieRight;

    @ApiModelProperty(value = "是否vip0元购专享  true:是  false:否 （vip0元购专享商品 && vip）")
    private Boolean vipZero;

    @ApiModelProperty(value = "双十一标签字段 0:不显示标签  1：双十一预售标签   2：双十一标签  特殊说明：新人专享标签优先级最高")
    private List<String> labelUrl;

    @ApiModelProperty(value = "商品图文详情")
    private List<CommodityDetailInfoDTO> commodityDetailInfos;

    @ApiModelProperty(value = "推荐头像")
    private String headImg;

    @ApiModelProperty(value = "vip佣金值", notes = "如果商品是0元购，则当前佣金值就为0元购的佣金金额")
    private Double vipCommissionPrice;

    @ApiModelProperty(value = "特殊返佣标志  true:是特殊返佣  false:普通返佣")
    private boolean specialCommissionFlag;

    @ApiModelProperty(value = "购买省-即优惠价格,当前佣金+优惠券")
    private Double favourablePrice;

    @ApiModelProperty(value = "多返的佣金,即vip佣金减去普通佣金")
    private Double extraCommissionPrice;

    /**
     * 数据来源：1好单库 2大淘客
     *
     * @see LocalCommoditySourceFrom
     */
    @ApiModelProperty(value = "数据来源：0三方数据 1好单库 2大淘客")
    private Byte source;
}
