package com.bxm.fossicker.commodity.model.dto;

import lombok.Builder;
import lombok.Data;
import lombok.experimental.Tolerate;

/**
 * 商品的扩展信息
 * vip价格、普通佣金价格、新人展示标志位等信息
 * @Author: Gonzo
 * @date  2020-03-02 14:57
 * @since 1.6.0
 */
@Data
@Builder
public class CommodityExtendInfo {

    /**
     * 是否新人专享  true:是  false:否
     */
    private boolean newbieRight;

    /**
     * 普通佣金值
     */
    private Double commissionPrice;

    /**
     * vip佣金值
     */
    private Double vipCommissionPrice;

    /**
     * 特殊返佣标志  true:是特殊返佣,不显示vip返佣金额  false:普通返佣
     */
    private boolean isSpecialCommissionFlag;

    /**
     * 商品价格（到手价）
     */
    private Double commodityPrice;

    @Tolerate
    public CommodityExtendInfo() {

    }
}
