package com.bxm.fossicker.commodity.model.dto;

import com.bxm.fossicker.commodity.common.enums.LocalCommodityStatusEnum;
import com.bxm.fossicker.constant.LocalCommoditySourceFrom;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Builder;
import lombok.Data;
import lombok.experimental.Tolerate;

import java.util.List;

/**
 * 商品详情服务返回的商品信息
 * 基本数据来源为本地库（好单库、大淘客）和淘宝抓取
 * 优惠券、佣金信息来源本地库（好单库、大淘客）和维易（1.6.0）
 * @author Gonzo
 * @date 2019-09-27 09:44
 */
@Data
@ApiModel("商品详情")
@Builder
public class CommodityInfoDTO {

    /**
     * 商品id
     */
    @ApiModelProperty(value = "商品id")
    private Long goodsId;

    /**
     * 商品标题
     */
    @ApiModelProperty(value = "商品标题")
    private String commodityTitle;

    /**
     * 商品图片list
     */
    @ApiModelProperty(value = "商品图片list")
    private List<String> imgUrlList;

    /**
     * 销量
     */
    @ApiModelProperty(value = "销量")
    private Integer salesNum;

    /**
     * 店铺名称
     */
    @ApiModelProperty(value = "店铺名称")
    private String shopName;

    /**
     * 店铺标志
     */
    @ApiModelProperty(value = "店铺标志")
    private String shopIcon;

    /**
     * 店铺链接url
     */
    @ApiModelProperty(value = "店铺链接url")
    private String shopUrl;

    @ApiModelProperty(value = " 店铺类型，1-天猫，0-淘宝")
    private Integer shopType;

    /**
     * 商品描述得分
     */
    @ApiModelProperty(value = "商品描述得分")
    private String commodityScore;

    /**
     * 卖家服务得分
     */
    @ApiModelProperty(value = "卖家服务得分")
    private String sellerScore;

    /**
     * 物流得分
     */
    @ApiModelProperty(value = "物流得分")
    private String logisticsScore;

    @ApiModelProperty(value = "商品原价")
    private Double reservePrice;

    @ApiModelProperty(value = "商品价格（到手价）= 商品原价 - 优惠券价格 - 佣金")
    private Double commodityPrice;

    @ApiModelProperty(value = "券后价 = 商品原价 - 优惠券价格")
    private Double discountPrice;

    @ApiModelProperty(value = "优惠券价格")
    private Double couponPrice;

    @ApiModelProperty(value = "佣金值 （三方平台给的佣金值）")
    private Double platformCommissionPrice;

    @ApiModelProperty(value = "优惠券链接" +
            "如果是已入库且上架的商品，在1.5.0之前会既时返回，1.5.0之后需调用4-09-01获取" +
            "如果是库外商品，则既时返回")
    private String couponUrl;

    @ApiModelProperty(value = "商品主图", hidden = true)
    private String mainPic;

    @ApiModelProperty(value = "推荐内容")
    private String recommendContent;

    /**
     * @see LocalCommodityStatusEnum
     */
    @ApiModelProperty(value = "商品状态：0下架 1上架")
    private Byte status;

    /**
     * 数据来源：1好单库 2大淘客
     * 字段名字错了...
     * @see LocalCommoditySourceFrom
     */
    private Byte soruce;

    @ApiModelProperty(value = "图文详情json")
    private List<CommodityDetailInfoDTO> detailInfo;


    @Tolerate
    public CommodityInfoDTO() {

    }
}
