package com.bxm.fossicker.commodity.model.dto;

import lombok.Builder;
import lombok.Data;

/**
 * 商品的价格信息
 * @Author: Gonzo
 * @date  2020-03-04 16:29
 * @since 1.6.0
 */
@Data
@Builder
public class CommodityPrice {

    /**
     * 普通佣金
     */
    private Double commissionPrice;

    /**
     * 券后价
     */
    private Double discountPrice;

    /**
     * 分享赚的钱
     */
    private Double shareCommissionPrice;

    /**
     * vip佣金
     */
    private Double vipCommissionPrice;

    /**
     * 商品最终购买价格
     */
    private Double commodityPrice;

    /**
     * 购买省价格
     */
    private Double favourablePrice;

    /**
     * 多返的佣金,即vip佣金减去普通佣金
     */
    private Double extraCommissionPrice;
}
