package com.bxm.fossicker.commodity.model.dto;


import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.util.List;

@ApiModel(description = "根据商品名查询商品列表结果DTO")
@Data
@Builder(toBuilder = true)
@AllArgsConstructor
@NoArgsConstructor
/**
 * 根据商品名查询商品列表结果DTO
 * @author Dong_hy
 */
public class CommoditySearchDTO {

    @ApiModelProperty(value = "商品id")
    private Long id;

    @ApiModelProperty(value = "淘宝商品id")
    private Long goodsId;

    @ApiModelProperty(value = "商品标题")
    private String commodityTitle;

    @ApiModelProperty(value = "商品价格")
    private Double commodityPrice;

    @ApiModelProperty(value = "商品原价")
    private Double reservePrice;

    @ApiModelProperty(value = "折后价")
    private Double discountPrice;

    @ApiModelProperty(value = "商品类型,1-淘抢购商品,2-聚划算商品 不填或0为全部商品")
    private Integer commodityType;

    @ApiModelProperty(value = "图片地址")
    private String imgUrl;

    @ApiModelProperty(value = " 店铺类型，1-天猫，0-淘宝")
    private Integer shopType;

    @ApiModelProperty(value = "优惠券价格")
    private Double couponPrice;

    @ApiModelProperty(value = "佣金值")
    private Double commissionPrice;

    @ApiModelProperty(value = "商铺名称")
    private String shopName;

    @ApiModelProperty(value = "月销量数")
    private Long monthSales;

    @ApiModelProperty(value = "惠好省金币可领状态,0:不可领,1:可领")
    private Integer goldStatus;

    @ApiModelProperty(value = "惠好省金币数量")
    private Integer goldNum;

    @ApiModelProperty(value = "是否新人专享  true:是  false:否")
    private Boolean newbieRight;

    @ApiModelProperty(value = "双十一标签字段 0:不显示标签  1：双十一预售标签   2：双十一标签  特殊说明：新人专享标签优先级最高")
    private List<String> labelUrl;

    @ApiModelProperty(value = "定金")
    private float handsel;

    @ApiModelProperty(value = "vip佣金值")
    private Double vipCommissionPrice;

    @ApiModelProperty(value = "特殊返佣标志  true:是特殊返佣,不显示vip返佣金额  false:普通返佣")
    private boolean specialCommissionFlag;

    @ApiModelProperty(value = "1表示搜索产品关键字，2表示转链,3:商品不存在对应淘客商品")
    private String searchType;

    @ApiModelProperty(value = "数据来源类型,1-库内,2-第三方")
    private Integer sourceType;

    @ApiModelProperty(value = "搜索结果备注信息，如果searchType为3时显示")
    private String remark;

}
