package com.bxm.fossicker.commodity.model.dto;

import lombok.Data;

@Data
public class DtkResultDTO {

    private static final int SUC_CODE = 0;

    private Long time;
    /**
     * 结果码
     */
    private Integer code;
    /**
     * 请求结果信息
     */
    private String msg;

    /**
     * 请求结果数据
     */
    private Object data;

    /**
     * 判断大淘客请求结果是否是成功
     * @param resultDTO 结果DTO
     * @return 成功返回true 失败返回false
     */
    public static boolean isFailed(DtkResultDTO resultDTO) {
        return null == resultDTO || SUC_CODE != resultDTO.getCode() || null == resultDTO.getData();
    }
}
