package com.bxm.fossicker.commodity.model.dto;

import lombok.Data;

/**
 * 好单库结果DTO
 * @author donghy
 */
@Data
public class HdkResultDTO {
    /**
     * 请求成功码
     */
    private static final int SUC_CODE = 1;

    /**
     * 请求结果码
     */
    private Integer code;

    /**
     * 请求结果信息
     */
    private String msg;

    /**
     * 请求结果数据
     */
    private Object data;

    public static boolean isFailed(HdkResultDTO resultDTO) {
        return null == resultDTO || SUC_CODE != resultDTO.getCode() || null == resultDTO.getData();
    }

}
