package com.bxm.fossicker.commodity.model.dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Builder;
import lombok.Data;
import lombok.experimental.Tolerate;

import java.util.List;

@ApiModel(description = "聚划算商品展示实体类")
@Data
@Builder
/**
 * 聚划算商品展示实体类
 * @author Dong_hy
 */
public class InexpensiveCommodityDTO {

    @Tolerate
    public InexpensiveCommodityDTO() {
    }

    @ApiModelProperty(value = "淘宝商品id")
    private Long goodsId;

    @ApiModelProperty(value = "商品标题")
    private String commodityTitle;

    @ApiModelProperty(value = "商品原价")
    private Double reservePrice;

    @ApiModelProperty(value = "商品价格")
    private Double commodityPrice;

    @ApiModelProperty(value = "店铺类型，1-天猫，0-淘宝")
    private Integer shopType;

    @ApiModelProperty(value = "图片url")
    private String imgUrl;

    @ApiModelProperty(value = "已抢购数量")
    private String soldNum;

    @ApiModelProperty(value = "优惠券价格")
    private Double couponPrice;

    @ApiModelProperty(value = "佣金值")
    private Double commissionPrice;

    @ApiModelProperty(value = "惠好省金币可领状态,0:不可领,1:可领")
    private Integer goldStatus;

    @ApiModelProperty(value = "惠好省金币数量")
    private Integer goldNum;

    @ApiModelProperty(value = "售卖状态,1-可售,0-已售完")
    private Integer soldStatus;

    @ApiModelProperty(value = "已售百分比")
    private Double soldPercent;

    @ApiModelProperty(value = "是否新人专享  true:是  false:否")
    private Boolean newbieRight;

    @ApiModelProperty(value = "双十一标签字段 0:不显示标签  1：双十一预售标签   2：双十一标签  特殊说明：新人专享标签优先级最高")
    private List<String> labelType;
}
