package com.bxm.fossicker.commodity.model.dto;

import lombok.Data;

import java.util.Date;

/**
 * 限时秒杀-淘抢购 商品信息对象DTO
 */
@Data
public class SecKillByTaoInfoDTO {

    /**
     * 商品id
     */
    private Long num_iid;

    /**
     * ；类目名称
     */
    private String category_name;

    /**
     * 商品链接（是淘客商品返回淘客链接，非淘客商品返回普通h5链接）
     */
    private String click_url;
    /**
     * 开始时间
     */
    private Date start_time;

    /**
     * 结束时间
     */
    private Date end_time;

    /**
     * 商品主图
     */
    private String pic_url;

    /**
     * 商品原价
     */
    private String reserve_price;

    /**
     * 已抢购数量
     */
    private Integer sold_num;


    /**
     * 商品标题
     */
    private String title;

    /**
     * 总库存
     */
    private Integer total_amount;

    /**
     * 淘抢购活动价
     */
    private String zk_final_price;

}
