package com.bxm.fossicker.commodity.model.dto;

import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Data;

import java.util.List;

@Data
public class WySearchCommodityInfoDTO {

    /**
     * 佣金 5000表示50%，即除以100）
     * 根据 searchType 返回的值确定单位
     */
    @JsonProperty("commission_rate")
    private String commissionRate;

    /**
     *  优惠券信息，如无此字段则表示没有优惠券 -- 优惠券面额从coupon_info中提取，格式固定是"满xx元减yy元"
     */
    @JsonProperty("coupon_info")
    private String couponInfo;

    /**
     * 商品描述
     */
    @JsonProperty("item_description")
    private String itemDescription;

    /**
     * 商品id
     */
    @JsonProperty("item_id")
    private Long itemId;

    /**
     * 商品id -- searchType为2时 商品id的值会存在这个字段
     */
    @JsonProperty("num_iid")
    private String numIid;
    /**
     * 产品地址
     */
    @JsonProperty("item_url")
    private String itemUrl;


    /**
     * 产品主图
     */
    @JsonProperty("pict_url")
    private String pictUrl;

    /**
     * 原价（未打折前原始标价，不是券前价哦）
     */
    @JsonProperty("reserve_price")
    private String reservePrice;

    /**
     * 卖家id
     */
    @JsonProperty("seller_id")
    private Long sellerId;

    /**
     * 卖家昵称
     */
    @JsonProperty("shop_title")
    private String shopTitle;

    /**
     * 短标题
     */
    @JsonProperty("short_title")
    private String shortTitle;

    /**
     * 其他主图
     */
    @JsonProperty("small_images")
    private List<String> smallImages;

    /**
     * 产品标题
     */
    @JsonProperty("title")
    private String title;

    /**
     * 卖家类型，0表示淘宝产品，1表示天猫商城
     */
    @JsonProperty("user_type")
    private Integer userType;

    /**
     *  30天销量
     */
    @JsonProperty("volume")
    private Long volume;

    /**
     * 商品折后价（券前价，就是产品在淘宝上折后价，你的程序的“券后价”是用此值减优惠券金额得到的）
     */
    @JsonProperty("zk_final_price")
    private String zkFinalPrice;

    /**
     * 店铺名称
     */
    @JsonProperty("nick")
    private String nick;
}
