package com.bxm.fossicker.commodity.model.dto;

import lombok.Builder;
import lombok.Data;
import lombok.experimental.Tolerate;

import java.util.List;

/**
 * 维易搜索结果信息DTO
 */
@Data
@Builder
public class WySearchResultDTO {

    @Tolerate
    public WySearchResultDTO() {
    }

    /**
     * 搜索类型
     * 接口返回值类型有2种：泛搜索和定向搜索，一定要看返回值search_type字段，返回值中search_type字段值为1时是泛搜索，2时是定向搜索（和万能转链hcapi接口一样）
     *
     * （1）泛搜索：这时接口返回search_type=1，返回值字段佣金比率“commission_rate”需要除以100，比如5000表示50%。
     *
     * （2）定向搜索：而如果搜索指定商品，此时search_type=2时，这时返回值中的commission_rate字段不需要除以100，是正常佣金百分值。如50.0表示50%
     */
    private String searchType;

    /**
     * 搜索结果消息
     */
    private String msg;

    /**
     * 数据信息
     */
    private List<WySearchCommodityInfoDTO> commodityList;
}
