package com.bxm.fossicker.commodity.model.entry;

import lombok.Builder;
import lombok.Data;
import lombok.experimental.Tolerate;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

/**
 * t_commodity_info
 * @author 
 */
@Data
@Builder
public class CommodityInfo implements Serializable {
    private Long id;

    /**
     * 商品id
     */
    private String goodId;

    /**
     * 商品标题
     */
    private String commodityTitle;

    /**
     * 商品价格-到手价,商品原价-优惠券价格-佣金
     */
    private BigDecimal commodityPrice;

    /**
     * 券后价,商品原价-优惠券价格
     */
    private BigDecimal discountPrice;

    /**
     * 商品原价
     */
    private BigDecimal reservePrice;

    /**
     * 商品类型,1-淘抢购商品,2-聚划算商品 不填或0为全部商品
     */
    private Byte commodityType;

    /**
     * 店铺类型，1-天猫，0-淘宝
     */
    private Byte shopType;

    /**
     * 优惠券价格
     */
    private BigDecimal couponPrice;

    /**
     * 佣金值
     */
    private BigDecimal commissionPrice;

    /**
     * 优惠券链接
     */
    private String couponUrl;

    /**
     * 商铺名称
     */
    private String shopName;

    /**
     * 月销量数
     */
    private Integer monthSales;

    /**
     * 总库存
     */
    private Long totalAmount;

    /**
     * 已抢购数量
     */
    private Long soldNum;

    /**
     * 开团时间
     */
    private Date startTime;

    /**
     * 结束时间
     */
    private Date endTime;

    /**
     * 主图
     */
    private String mainPic;

    /**
     * 销量
     */
    private Integer salesNum;

    /**
     * 店铺标志
     */
    private String shopIcon;

    /**
     * 店铺链接url
     */
    private String shopUrl;

    /**
     * 商品描述得分
     */
    private String commodityScore;

    /**
     * 卖家服务得分
     */
    private String sellerScore;

    /**
     * 物流得分
     */
    private String logisticsScore;

    /**
     * 商品状态：0下架 1上架
     */
    private Byte status;

    /**
     * 数据来源：1好单库 2大淘客
     */
    private Byte soruce;

    private Date createTime;

    private Date modifyTime;

    /**
     * 推荐语
     */
    private String recommendContent;

    /**
     * 商品图片list
     */
    private String imgUrlList;

    /**
     * 图文详情json
     */
    private String detailInfo;


    @Tolerate
    public CommodityInfo() {

    }

}