package com.bxm.fossicker.commodity.model.param;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

@Data
public class CategoryCommodityListParam extends CommodityListParam {

    @ApiModelProperty(value = "价格下限")
    private String priceLowerLimit;

    @ApiModelProperty(value = "价格上限  ")
    private String priceUpperLimit;

    @ApiModelProperty(value = "默认为0，0-综合排序，2-销量降序,4-佣金比降序")
    private String sortType;

    @ApiModelProperty(value = "一级分类ID")
    private String cids;

    @ApiModelProperty(value = "二级分类ID  (分类搜索是必传,分类搜索不需要传一级类目id，仅允许传一个二级id，" +
            "当一级类目id和二级类目id同时传入时，会自动忽略二级类目id )",required = true )
    private String subcid;

    @ApiModelProperty(value = "每页条数" )
    private int pageSize = 50;

    @ApiModelProperty(value = "当前页")
    private int pageOn = 1;
}
