package com.bxm.fossicker.commodity.model.param;

import com.bxm.fossicker.commodity.model.constant.CommodityDetailType;
import com.bxm.fossicker.vo.BasicParam;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Builder;
import lombok.Data;
import lombok.experimental.Tolerate;

/**
 * 商品详情请求参数
 * @Author: Gonzo
 * @Date 2020-02-10 16:15
 * @since 1.5.0
 */
@Data
@ApiModel(description = "商品详情")
@Builder
public class CommodityDetailParam extends BasicParam {

    @ApiModelProperty(value = "查询名称")
    private Long goodsId;

    @ApiModelProperty(value = "查询名称")
    private Long userId;

    @ApiModelProperty(value = "是否h5")
    private boolean h5Flag;

    @ApiModelProperty(value = "跳转来源：1：搜索列表 2：首页精选等其他分类列表")
    private Byte jumpType;

    /**
     * @see CommodityDetailType
     */
    @ApiModelProperty(value = "详情获取类型 0：默认商品详情 1：vip0元购商品详情", notes = "不传的话，默认值为0")
    private Integer detailType = 0;

    @Tolerate
    public CommodityDetailParam() {
    }
}
