package com.bxm.fossicker.commodity.model.param;

import com.bxm.fossicker.vo.BasicParam;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.ToString;
import lombok.experimental.Tolerate;

/**
 * 商品详情查询参数
 *
 * @author liujia
 * @date 2020/01/14 16:11
 */
@EqualsAndHashCode(callSuper = true)
@ToString
@Data
@Builder
public class CommodityDetailQueryParam extends BasicParam {

    @Tolerate
    public CommodityDetailQueryParam() {
    }

    /**
     * 查询的用户ID，用于获取奖励标识和VIP信息
     */
    private Long userId;

    /**
     * 是否VIP，未提供（等于null）的情况下会查询VIP信息
     */
    private Boolean vipUser;

    /**
     * 是否是新人
     * 未提供（等于null）的情况下会查询用户信息
     */
    private Boolean newbieRightUser;

    /**
     * 淘宝商品ID
     */
    private Long goodsId;

    /**
     * 跳转来源：1：搜索列表 2：首页精选等其他分类列表
     * 用来标识，数据源的获取方式
     */
    private Byte jumpType;

    /**
     * @see com.bxm.fossicker.commodity.model.constant.CommodityDetailType
     * 查询详情的类型 0：默认商品详情 1：vip0元购商品详情
     */
    private Integer detailType = 0;

    /**
     * 是否在H5中显示
     */
    private boolean h5Flag;

    /**
     * 是否查询浏览奖励
     */
    private boolean queryBrowerAward;

    /**
     * 是否需要判断为新人奖励
     */
    private boolean queryNewbie;

    /**
     * 查询收藏信息
     */
    private boolean queryCollect;

    /**
     * 查询提醒信息
     */
    private boolean queryRemind;

    /**
     * 是否查询商品详情（图文详情）
     */
    private boolean queryDetail;

    /**
     * 是否查询分享赚钱的相关信息
     */
    private boolean queryShare;

    /**
     * 是否设置商品标签信息
     */
    private boolean setLable;

    /**
     * 是否保存浏览历史
     */
    private boolean saveHistory;

    /**
     * 是否只查询本地数据
     */
    private boolean queryLocalOnly;

    /**
     * 是否查询优惠券信息
     */
    private boolean queryCouponInfo;

    /**
     * 是否校验佣金信息
     */
    private boolean validateCommissionPriceInfo;

    /**
     * 校验优惠券金额
     */
    private boolean validateCouponPriceInfo;

    /**
     * 维易转换对象请求参数
     */
    private WySearchCommodityInfoParam wySearchCommodityInfoParam;

    /**
     * 是否是公开接口的请求
     * 因为公开接口可能没有用户信息，所以针对这些请求，一些条件过滤可以去掉
     * 如，vip0元购商品在站外也是可以获取的，但是站外并没有用户信息就无法判断是否vip用户了
     */
    private boolean publicRequest;

    /**
     * 是否不打印查询失败的日志
     */
    private boolean doNotPrintWarnLog;

    /**
     * 是否当校验失败时，返回基础信息
     */
    private boolean ifNotValidThenReturnBaseInfo;
}
