package com.bxm.fossicker.commodity.model.param;

import com.bxm.fossicker.vo.BasicParam;
import lombok.Data;

@Data
public class CommodityListParam extends BasicParam {

    /**
     * 用户id
     */
    private Long userId;

    /**
     * 每页条数
     * 需要分页的接口可以用
     */
    private int pageSize = 10;

    /**
     * 当前页
     * 需要分页的接口可以用
     */
    private int pageOn = 1;

    /**
     * 是否vip
     */
    private Boolean vip;

    /**
     * 是否新人
     */
    private Boolean newbieRight;

    /**
     * 是否是公开接口的请求
     * 因为公开接口可能没有用户信息，所以针对这些请求，一些条件过滤可以去掉
     * 如，vip0元购商品在站外也是可以获取的，但是站外并没有用户信息就无法判断是否vip用户了
     */
    private boolean publicRequest;

    // 查询额外信息参数开关

    /**
     * 是否查询标签
     */
    private boolean queryLabel;

    /**
     * 是否查询金币信息
     */
    private boolean queryGoldInfo;
}
