package com.bxm.fossicker.commodity.model.param;

import com.bxm.newidea.component.vo.BaseBean;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;


/**
 * 商品查询参数实体
 * @author Dong_hy
 */
@ApiModel(description = "根据商品名查询商品列表")
@Data
public class CommoditySearchParam extends BaseBean {

    @ApiModelProperty(value = "用户id", required = true)
    private Long userId;

    @ApiModelProperty(value = "商品名称关键词", required = true)
    private String commodityName;

    @ApiModelProperty(value = "价格（券后价）上限")
    private Long priceUpperLimit;

    @ApiModelProperty(value = "价格（券后价）下限")
    private Long priceLowerLimit;

    @ApiModelProperty(value = "1表示该商品有优惠券,0为不限")
    private Integer couponFlag;

    @ApiModelProperty(value = "默认为0，0-综合排序，1-销量降序,2-佣金比降序")
    private String sortType;

    @ApiModelProperty(value = "每页条数")
    private Integer pageSize = 10;

    @ApiModelProperty(value = "页码")
    private Integer pageNum = 1;

}
