package com.bxm.fossicker.commodity.model.param;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * @Author: pf.w
 * @Date: 2019/7/8 19:59
 */
@ApiModel(description = "商品列表信息参数")
@Data
public class GoodsListRequestParam {

    @ApiModelProperty(value = "用户id", required = true)
    private Long userId;

    @ApiModelProperty(value = "一级分类id")
    private String cid;

    @ApiModelProperty(value = "二级分类id  当一级类目id和二级类目id同时传入时，会自动忽略二级类目id")
    private String subcid;

    @ApiModelProperty(value = "分类   LIKE:猜你喜欢; WELLCHOSE:精选;  NOMAL: 其他分类 ；ZERO : 零元购",required = true)
    private String type;

    @ApiModelProperty(value = "每页条数" ,required = true)
    private int pageSize;

    @ApiModelProperty(value = "当前页" ,required = true)
    private int pageOn;
}
