package com.bxm.fossicker.commodity.model.param;


import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

@ApiModel(description = "聚划算商品列表请求参数")
@Data
/**
 * 聚划算商品列表请求参数
 * @author Dong_hy
 */
public class InexpensiveCommodityParam {

    @ApiModelProperty(value = "用户id")
    private Long userId;

    @ApiModelProperty(value = "默认为0，0-综合排序，1-商品上架时间从高到低，2-销量从高到低，3-领券量从高到低，4-佣金比例从高到低，" +
            "5-价格（券后价）从高到低，6-价格（券后价）从低到高")
    private Integer sortType;

    @ApiModelProperty(value = "价格（券后价）上限")
    private Integer priceUpperLimit;

    @ApiModelProperty(value = "价格（券后价）下限")
    private Integer priceLowerLimit;

    @ApiModelProperty(value = "pageId 第一次请求填1,之后的值填返回的pageId值")
    private String pageId = "1";

    @ApiModelProperty(value = "页码大小")
    private Integer pageSize = 10;

}
