package com.bxm.fossicker.commodity.model.param;

import com.bxm.fossicker.commodity.model.dto.CommodityInfoDTO;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * 广告卷商品信息对照数据
 * @Author: pf.w
 * @Date: 2019/10/30 16:36
 */
@Data
public class TicketInfo extends CommodityInfoDTO {

    /**
     * 广告卷素材id
     */
    private Long assetId;

    /**
     * 广告卷id
     */
    private Long ticketId;

    /**
     * 优惠券价格
     */
    private Double couponPrice;


    /**
     * 佣金值 （三方平台给的佣金值）
     */
    private Double platformCommissionPrice;

    /**
     * 素材图片url
     */
    private String url;
}
