package com.bxm.fossicker.commodity.model.param;

import com.bxm.fossicker.commodity.model.dto.WySearchCommodityInfoDTO;
import lombok.Builder;
import lombok.Data;

/**
 * 维易搜索对象转换为商品信息的请求参数
 * 因为一个对象被之前两个地方使用（搜索、猜你喜欢）
 * 而两个地方进行转化的代码有不相同
 * 现在将商品信息代码统一化
 * 为了避免出现错误，就将这两分转换代码都保留
 * @Author: Gonzo
 * @date  2020-03-06 17:25
 * @since 1.6.0
 */
@Data
@Builder
public class WySearchCommodityInfoParam {

    /**
     * 维易搜索对象
     * 如果当前字段不为空，就从当前对象中获取商品基本信息进行转换
     */
    private WySearchCommodityInfoDTO wyInfo;

    /**
     * 维易搜索的时候的类型
     */
    private String searchType;

    /**
     * 转换类型
     * 1：搜索列表的转换
     * 2：猜你喜欢列表的转换
     */
    private Byte convertType;
}
