package com.bxm.fossicker.commodity.model.vo;

import com.bxm.fossicker.constant.LocalCommoditySourceFrom;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.util.List;

/**
 * 列表商品的基本数据对象
 * 如果不是基本字段，请不要在对象中添加字段！！！！！！
 * 各种自定义列表，自己继承当前对象去添加字段！！！
 *
 * @Author: Gonzo
 * @date 2020-03-02 15:30
 * @since 1.6.0
 */
@ApiModel(description = "列表商品的基本数据对象")
@Data
@Builder(toBuilder = true)
@AllArgsConstructor
@NoArgsConstructor
public class BaseCommodityListItem {

    @ApiModelProperty(value = "淘宝商品id")
    private Long goodsId;

    @ApiModelProperty(value = "商品标题")
    private String commodityTitle;

    @ApiModelProperty(value = "商品价格")
    private Double commodityPrice;

    @ApiModelProperty(value = "商品原价")
    private Double reservePrice;

    @ApiModelProperty(value = "折后价")
    private Double discountPrice;

    @ApiModelProperty(value = "图片地址")
    private String imgUrl;

    @ApiModelProperty(value = " 店铺类型，1-天猫，0-淘宝")
    private Integer shopType;

    @ApiModelProperty(value = "优惠券价格")
    private Double couponPrice;

    @ApiModelProperty(value = "最终的佣金值", notes = "可能是普通佣金，也可能是vip佣金 也可能是0元购的佣金等")
    private Double commissionPrice;

    @ApiModelProperty(value = "商铺名称")
    private String shopName;

    @ApiModelProperty(value = "月销量数")
    private Long monthSales;

    @ApiModelProperty(value = "是否新人专享  true:是  false:否")
    private Boolean newbieRight;

    @ApiModelProperty(value = "vip佣金值", notes = "如果商品是0元购，则当前佣金值就为0元购的佣金金额")
    private Double vipCommissionPrice;

    @ApiModelProperty(value = "特殊返佣标志  true:是特殊返佣,不显示vip返佣金额  false:普通返佣")
    private boolean specialCommissionFlag;

    @ApiModelProperty(value = "双十一标签字段 0:不显示标签  1：双十一预售标签   2：双十一标签  特殊说明：新人专享标签优先级最高")
    private List<String> labelUrl;


    @ApiModelProperty(value = "惠好省金币可领状态,0:不可领,1:可领")
    private Integer goldStatus;

    @ApiModelProperty(value = "惠好省金币数量")
    private Integer goldNum;

    /**
     * 数据来源：1好单库 2大淘客
     *
     * @see LocalCommoditySourceFrom
     */
    @ApiModelProperty(value = "数据来源：0三方数据 1好单库 2大淘客")
    private Byte source;

}
