package com.bxm.fossicker.commodity.model.vo;

import lombok.Data;
import lombok.ToString;

import java.io.Serializable;
import java.util.Date;

/**
 * <p>
 * 用户商品浏览历史记录
 * </p>
 *
 * @author X.Zhao
 * @since 2019-07-02
 */
@Data
@ToString
public class CommodityBrowseFlow implements Serializable {

    private static final long serialVersionUID = 1L;

    /**
     * 主键
     */
    private Long id;
    /**
     * 用户ID
     */
    private Long userId;

    /**
     * 商品分享者id
     */
    private Long shareUserId;

    /**
     * 商品ID
     */
    private Long goodsId;

    /**
     * 浏览类型:1-自身浏览记录,2-浏览分享商品记录
     */
    private Integer browseType;

    /**
     * 浏览时间
     */
    private Date createTime;
}
