package com.bxm.fossicker.commodity.model.vo;

import com.bxm.fossicker.commodity.model.constant.LowershelfSignEnum;
import com.bxm.fossicker.vo.BaseBean;
import lombok.Data;

/**
 * @Description: 商品池服务下架
 * @author: yangxin
 * @date: 2019/12/26  10:43
 */
@Data
public class CommodityPoolStatusVO extends BaseBean {

    private Long poolsId;

    /**
     * 淘宝商品id啊
     */
    private String goodsId;

    /**
     * 商品状态，1-上架，2-下架
     */
    private Byte statusType;

    /**
     * 下架备注 1-商品价格变动自动下架，2-商品失效自动下架，3-定时下架，4-手动下架
     * @see LowershelfSignEnum
     */
    private String lowershelfSign;
}
