package com.bxm.fossicker.commodity.model.vo;

import com.bxm.fossicker.constant.LocalCommoditySourceFrom;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Builder;
import lombok.Data;
import lombok.experimental.Tolerate;

/**
 * 会员精选商品列表对象
 *
 * @Author: Gonzo
 * @Date 2020-02-27 17:25
 * @since 1.6.0
 */
@ApiModel(description = "会员精选商品列表对象")
@Data
@Builder(toBuilder = true)
public class VipChoicenessCommodityListVO {

    @ApiModelProperty(value = "淘宝商品id")
    private Long goodsId;

    @ApiModelProperty(value = "商品标题")
    private String commodityTitle;

    @ApiModelProperty(value = "商品价格（到手价）= 商品原价 - 优惠券价格 - 佣金")
    private Double commodityPrice;

    @ApiModelProperty(value = "商品原价")
    private Double reservePrice;

    @ApiModelProperty(value = "折后价（券后价） = 商品原价 - 优惠券价格")
    private Double discountPrice;

    @ApiModelProperty(value = "优惠券价格")
    private Double couponPrice;

    @ApiModelProperty(value = "商品主图图片地址")
    private String imgUrl;

    @ApiModelProperty(value = " 店铺类型，1-天猫，0-淘宝")
    private Integer shopType;

    @ApiModelProperty(value = "最终的返佣金额 （可能是vip佣金，可能是0元购佣金，也可能只是普通佣金）")
    private Double commissionPrice;

    @ApiModelProperty(value = "vip佣金值")
    private Double vipCommissionPrice;

    @ApiModelProperty(value = "月销量数")
    private Long monthSales;

    @ApiModelProperty(value = "月销量数字符串（当销量过万时会进行单位转换 如123000会呈现为12.3万）")
    private String monthSalesStr;

    @ApiModelProperty(value = "商铺名称")
    private String shopName;

    @ApiModelProperty(value = "惠好省金币可领状态,0:不可领,1:可领")
    private Integer goldStatus;

    @ApiModelProperty(value = "惠好省金币数量")
    private Integer goldNum;

    /**
     * 数据来源：1好单库 2大淘客
     *
     * @see LocalCommoditySourceFrom
     */
    @ApiModelProperty(value = "数据来源：0三方数据 1好单库 2大淘客")
    private Byte source;

    @Tolerate
    public VipChoicenessCommodityListVO() {

    }

}
