package com.bxm.fossicker.commodity.model.vo;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Builder;
import lombok.Data;

/**
 * 会员0元购商品列表对象
 * @Author: Gonzo
 * @Date 2020-02-27 17:25
 * @since 1.6.0
 */
@ApiModel(description = "会员0元购商品列表对象")
@Data
@Builder(toBuilder = true)
public class VipZeroCommodityListVO {

    @ApiModelProperty(value = "淘宝商品id")
    private Long goodsId;

    @ApiModelProperty(value = "商品标题")
    private String commodityTitle;

    @ApiModelProperty(value = "商品价格（到手价）= 商品原价 - 优惠券价格 - 佣金")
    private Double commodityPrice;

    @ApiModelProperty(value = "商品原价")
    private Double reservePrice;

    @ApiModelProperty(value = "商品主图图片地址")
    private String imgUrl;

    @ApiModelProperty(value = " 店铺类型，1-天猫，0-淘宝")
    private Integer shopType;

    @ApiModelProperty(value = "月销量数")
    private Long monthSales;

    @ApiModelProperty(value = "商铺名称")
    private String shopName;

}
