package com.bxm.fossicker.commodity.config;

import lombok.Data;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.stereotype.Component;

/**
 * @Author: pf.w
 * @Date: 2019/10/29 14:45
 */
@Component
@ConfigurationProperties("commodity.config.ticket")
@Data
public class AdvertTicketProperties {

    /**
     * 新增素材
     */
    private String adAssetUrl;

    /**
     * 修改素材
     */
    private String updateAssetUrl;

    /**
     * 新增广告卷
     */
    private String adTicketUrl;

    /**
     * 修改广告卷
      */
    private String upTicketUrl;


    /**
     * 修改广告卷状态
     */
    private String upStatusTicketUrl;

    /**
     * 头部token
     */
    private String token;

    /**
     * 广告卷底图
     */
    private String bgImgUrl;

    /**
     * 广告主
     */
    private String advertiser;

    /**
     * 广告标签
     */
    private String tags;

    /**
     * 广告分类
     */
    private String domainCode;

    /**
     * 广告AE
     */
    private String ae;

    /**
     * 解析bxmId地址
     */
    private String parseBxmIdUrl;

    /**
     * 同步订单效果监控地址
     */
    private String sendOrderUrl;
}
