package com.bxm.fossicker.commodity.config;

import lombok.Data;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.stereotype.Component;

import java.math.BigDecimal;

/**
 * 佣金配置信息
 * 1.5.0之前的配置信息有一部分写在 {@link CommodityInfoProperties} 中
 * @Author: Gonzo
 * @Date 2020-02-08 11:03
 * @since 1.5.0
 */
@Component
@ConfigurationProperties("commodity.config.commission")
@Data
public class CommissionProperties {

    private Ele ele = new Ele();




    /**
     * 饿了么返佣
     */
    @Data
    public class Ele {

        /**
         * 自购通用佣金比例
         * 相对于支付金额而不是订单的佣金金额
         * 默认5%
         */
        private BigDecimal commonCommissionPurchaseRateForPayPrice = BigDecimal.valueOf(0.05);

        /**
         * vip自购佣金比例
         * 相对于支付金额而不是订单的佣金金额
         * 默认5% 和普通自购价格一致
         */
        private BigDecimal vipPurchaseRateForPayPrice = BigDecimal.valueOf(0.05);

        /**
         * 上级通用佣金比例
         * 相对于支付金额而不是订单的佣金金额
         * 默认0
         */
        private BigDecimal commonCommissionRateParentForPayPrice = BigDecimal.ZERO;

        /**
         * 上上级通用佣金比例
         * 相对于支付金额而不是订单的佣金金额
         * 默认0
         */
        private BigDecimal commonCommissionRateGrandParentForPayPrice = BigDecimal.ZERO;
    }
}
