package com.bxm.fossicker.commodity.config;

import lombok.Data;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.stereotype.Component;

@Component
@ConfigurationProperties("commodity.config.search")
@Data
/**
 * 商品信息配置类
 * @author Dong_hy
 */
public class CommodityInfoProperties {

    /**
     * 大淘客搜索商品请求地址
     */
    private String dtkCommodityUrl;

    /**
     * 大淘客搜索商品版本号
     */
    private String dtkCommodityVersion;

    /**
     * 大淘客搜索商品app key
     */
    private String dtkCommodityAppKey;

    /**
     * 大淘客搜索商品详情url
     */
    private String dtkCommodityDetailUrl;

    /**
     * 大淘客分类url
     */
    private String dtkSuperCategoryUrl;

    /**
     * 分类搜索url
     */
    private String dtkCategorySearchUrl;

    /**
     * 大淘客搜索商品app secret
     */
    private String dtkCommodityAppSecret;

    /**
     * 淘宝商品服务url
     */
    private String tbCommodityUrl;

    /**
     * 淘宝商品服务app key
     */
    private String tbCommodityAppKey;

    /**
     * 淘宝商品服务app secret
     */
    private String tbCommodityAppSecret;

    /**
     * 淘宝商品服务查询接口 adZoneId
     */
    private String tbCommodityZoneId;

    /**
     * 好单库商品服务url
     */
    private String hdkCommodityUrl;

    /**
     * 好单库商品单品详情服务url
     */
    private String hdkCommodityDetailUrl;

    /**
     * 好单库精选列表url
     */
    private String hdkRankListUrl;

    /**
     * 好单库商品服务app key
     */
    private String hdkCommodityAppKey;

    /**
     * 好单库商品服务pid
     */
    private String hdkCommodityPid;

    /**
     * 自购通用佣金比例
     */
    private String commonCommissionPurchase;

    /**
     * 上级通用佣金比例
     */
    private String commonCommissionParent;

    /**
     * 上上级通用佣金比例
     */
    private String commonCommissionGrandParent;

    /**
     * 浏览商品金币
     */
    private Integer browseCommonGold = 24;

    /**
     * 轻淘客appkey
     */
    private String qtkAppKey;

    private String qtkVersion;

    /**
     * 轻淘客热门搜索
     */
    private String qtkHotSearchUrl;

    /**
     * 每日领取金币上限次数
     */
    private Integer maxDrawGoldTimes;

    /**
     * 卖家推荐默认头像list
     */
    private String headImgList;

    private String startTimeForDouble11;

    private String endTimeForDouble11;

    /**
     * 淘宝联盟AppKey
     */
    private String tblmCommodityAppKey;

    /**
     * 淘宝联盟AppSecret
     */
    private String tblmCommodityAppSecret;

    /**
     * 新人专享最大价格
     */
    private int newbieMaxPrice;

    /**
     * vip 0元购补贴最大价格
     */
    private Integer vipZeroMaxPrice = 6;

    /**
     * 维易搜索接口url
     */
    private String wySearchUrl;

    /**
     * 维易高佣接口url
     */
    private String wyCommissionUrl;

    /**
     * 维易猜你喜欢接口url
     */
    private String wyGuessUrl;

    /**
     * 粘贴板请求数据来源，可选值为：weiyi、taobao
     */
    private String searchSource = "weiyi";

}
