package com.bxm.fossicker.commodity.config;

import lombok.Data;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.stereotype.Component;

@Component
@ConfigurationProperties("commodity.list")
@Data
public class CommodityListProperties {

    /**
     * 列表缓存开关，用来控制列表即时获取，便于调试
     * true 开启缓存
     * false 关闭缓存
     */
    private Boolean cacheSwitch = Boolean.TRUE;

    /**
     * 商品池商品缓存时间
     * 默认60s
     */
    private Long poolCommodityListCacheTimeSecond = 1L * 60;
}
