package com.bxm.fossicker.commodity.config;

import lombok.Data;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.stereotype.Component;

/**
 * vip 0元购商品配置信息
 * @Author: Gonzo
 * @date  2020-03-02 10:10
 * @since 1.6.0
 */
@Component
@ConfigurationProperties("commodity.config.vip-zero")
@Data
public class VipZeroCommodityProperties {

    /**
     * 简略类表数量
     */
    private Integer briefNum = 6;

    /**
     * 购买信息（跑马灯）数量
     * 默认20条
     */
    private Integer purchaseInfosNum = 20;

    /**
     * 跑马灯失效时间
     * 默认10分钟
     */
    private Integer purchaseCacheExpireSecond = 60 * 10;
}
