package com.bxm.fossicker.commodity.convert;

import com.bxm.fossicker.commodity.model.dto.CommodityDetailDTO;
import com.bxm.fossicker.commodity.model.dto.CommoditySearchDTO;
import com.bxm.fossicker.constant.LocalCommoditySourceFrom;
import org.springframework.beans.BeanUtils;

import java.util.Objects;

/**
 * 商品详情转化为查询对象
 *
 * @author liujia
 * @date 2020/01/16 17:33
 */
public class CommodityDetailToSearchConvert {

    private CommodityDetailToSearchConvert() {
    }

    public static CommoditySearchDTO convert(CommodityDetailDTO detail) {
        // 如果查询失败，则直接返回null
        if (Objects.isNull(detail) || !Objects.equals(detail.getValidStatus(), 1)) {
            return null;
        }

        CommoditySearchDTO searchDetail = CommoditySearchDTO.builder()
                //.searchType(StringUtils.isEmpty(searchType) ? SearchType.CONVERT_LINK : searchType)
                .goodsId(detail.getGoodsId())
                .imgUrl(detail.getMainPic())
                .monthSales(detail.getSalesNum() == null ? 0L : detail.getSalesNum())
                // 数据来源 1-库内,2-第三方
                .sourceType(Objects.equals(detail.getSource(), LocalCommoditySourceFrom.THIREDPARTY) ? 2 : 1)
                .build();

        BeanUtils.copyProperties(detail, searchDetail);

        return searchDetail;
    }
}
