package com.bxm.fossicker.commodity.facade;

import com.alibaba.fastjson.JSONObject;
import com.bxm.fossicker.commodity.common.constants.CommodityRedisKeyConstants;
import com.bxm.fossicker.commodity.domain.CommodityPoolMapper;
import com.bxm.fossicker.commodity.model.constant.CommodityPoolId;
import com.bxm.fossicker.commodity.model.param.CommodityQuartStatusParam;
import com.bxm.fossicker.commodity.model.vo.CommodityPoolStatusVO;
import com.bxm.newidea.component.redis.KeyGenerator;
import com.bxm.newidea.component.redis.RedisSetAdapter;
import com.bxm.newidea.component.redis.RedisStringAdapter;
import com.bxm.newidea.component.schedule.task.AbstractTaskCallback;
import com.xxl.job.core.biz.model.ReturnT;
import lombok.extern.log4j.Log4j2;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.Objects;

/**
 * @Description: 商品池商品定时上架
 * @author: yangxin
 * @date: 2019/12/26  19:38
 */
@Component
@Log4j2
public class CommodityQuartUpperShelfTask extends AbstractTaskCallback<CommodityQuartStatusParam> {

    @Autowired
    private CommodityPoolMapper poolMapper;

    @Autowired
    private RedisSetAdapter redisSetAdapter;

    @Autowired
    private RedisStringAdapter redisStringAdapter;

    @Override
    protected ReturnT<String> service(CommodityQuartStatusParam quartStatus) {
        log.info("商品池商品上架, 请求参数:[{}]", JSONObject.toJSONString(quartStatus));

        try {

            CommodityPoolStatusVO poolStatusVO = new CommodityPoolStatusVO();
            poolStatusVO.setGoodsId(quartStatus.getGoodsId());
            poolStatusVO.setPoolsId(quartStatus.getPoolsId());
            poolStatusVO.setStatusType((byte) 1);
            poolMapper.updateCommodityStatus(poolStatusVO);

            // 清除redis商品缓存
            redisStringAdapter.remove(getKeyGenerator(quartStatus.getPoolsId(), "isVip"));
            redisStringAdapter.remove(getKeyGenerator(quartStatus.getPoolsId(), "noVip"));

            // 如果是添加新人商品
            if (Objects.equals(CommodityPoolId.NOVICE, quartStatus.getPoolsId())) {
                // 添加到缓存set中
                redisSetAdapter.add(CommodityRedisKeyConstants.COMMODITY_NEWBIE_SET,
                        Objects.toString(quartStatus.getGoodsId()));
            }

            // 如果是添加vip 0元购商品
            if (Objects.equals(CommodityPoolId.VIP_ZERO, quartStatus.getPoolsId())) {
                // 添加到缓存set中
                redisSetAdapter.add(CommodityRedisKeyConstants.COMMODITY_VIP_ZERO_SET,
                        Objects.toString(quartStatus.getGoodsId()));
            }

            return ReturnT.SUCCESS;
        } catch(Exception e) {
            log.error("商品池商品上架出现错误, 请求参数:[{}]", JSONObject.toJSONString(quartStatus), e);
        }

        return ReturnT.FAIL;
    }

    /**
     * 获取key
     *
     * @param poolId 商品池id
     * @param vipOrNot vip信息
     * @return key
     */
    private KeyGenerator getKeyGenerator(Long poolId, String vipOrNot) {
        return CommodityRedisKeyConstants.COMMODITY_GOODS_LIST_EXTEND.copy().appendKey(poolId).appendKey(vipOrNot);
    }
}
