package com.bxm.fossicker.commodity.service;

import com.bxm.fossicker.commodity.model.param.BrowseCommodityParam;

/**
 * 用户浏览记录服务
 *
 * @ClassName BrowseFlow
 * @CopyRright (c) 2019-bxm：杭州微财网络科技有限公司
 * @Author XinZhao
 * @Date 2019/7/2 14:26
 * @Version 1.0.0
 **/
public interface BrowseFlowService {

    /**
     * 查询用户当天是否浏览过该商品
     * @param commodityId 商品id
     * @param userId 用户id
     * @return 用户当天浏览过返回true,未浏览过返回false
     */
    Boolean isBrowseCommodityByToday(Long commodityId, Long userId);

    Boolean addBrowseCommodityRecord(BrowseCommodityParam browseCommodityParam);


    /**
     * 添加浏览分享商品记录
     * @param browseUserId 浏览者用户id
     * @param shareUserId 分享者用户id
     * @param goodsId 商品id
     * @return
     */
    Boolean addBrowseShareCommodityRecord(Long browseUserId, Long shareUserId, Long goodsId);
}
