package com.bxm.fossicker.commodity.service;

import com.bxm.fossicker.commodity.model.param.CollectCommodityParam;
import com.bxm.fossicker.commodity.model.vo.CommodityCollectionVO;

import java.util.List;

public interface CommodityCollectService {

    /**
     * 获取商品的收藏状态
     * @param commodityId 商品id
     * @param userId 用户id
     * @return 1-已收藏,0-未收藏
     */
    Integer getCollectStatus(Long commodityId, Long userId);

    /**
     * 修改收藏状态
     * @param collectCommodityParam 收藏商品请求参数
     * @return 修改结果
     */
    Integer changeCollectStatus(CollectCommodityParam collectCommodityParam);

    /**
     * 获取用户收藏
     * @param userId 用户id
     * @return 返回用户收藏记录
     */
    List<CommodityCollectionVO> gerUserCollection(Long userId);
}
