package com.bxm.fossicker.commodity.service;

import com.bxm.fossicker.commodity.model.dto.CommodityCouponInfoFromSuper;
import com.bxm.fossicker.commodity.model.vo.CommodityCouponInfo;
import com.bxm.fossicker.integration.param.GetCouponInfoParam;

/**
 * 优惠券信息相关服务
 * @Author: Gonzo
 * @Date 2020-02-12 21:10
 * @since 1.5.0
 */
public interface CommodityCouponInfoService {

    /**
     * 获取高佣优惠券连接
     * 只有库内商品才可以使用，三方数据（1.6.0为维易）是获取不到的
     * 供商品详情页，点击去购买时调用，所以如果是三方数据的话，会在详情页直接返回而不需要调用这个方法
     * @param param param
     * @return 高佣优惠券连接
     */
    CommodityCouponInfo getCommodityCouponInfo(GetCouponInfoParam param);

    /**
     * 根据商品类型组装couponUrl-将优惠券的地址前缀https改成tbopen,使得客户端可以跳转至淘宝客户端
     *
     * @param couponUrl 优惠券url
     * @return 组装后的couponUrl
     */
    String assembleCouponUrlByType(String couponUrl);

    /**
     * 获取获取商品优惠信息（超级入口商品详情页调用）
     * 老版本代码，兼容用的，以后不允许使用
     * @param goodsId 商品id
     * @param userId  用户id
     * @return 商品优惠信息
     */
    @Deprecated
    CommodityCouponInfoFromSuper getCouponInfo(Long goodsId, Long userId);
}
