package com.bxm.fossicker.commodity.service;

import com.bxm.fossicker.commodity.model.dto.CommodityGoldInfoDTO;
import com.bxm.fossicker.commodity.model.dto.CommoditySearchDTO;
import com.bxm.fossicker.commodity.model.param.BrowseCommodityParam;
import com.bxm.fossicker.commodity.model.param.GoodsListRequestParam;

import java.util.List;

public interface CommodityGoldService {

    /**
     * 根据商品id和用户id获取商品金币信息-商品对应金币数以及是否可领
     * @param commodityId 商品id
     * @param userId 用户id
     * @return 返回商品对应的金币信息
     */
    CommodityGoldInfoDTO getGoldInfoByCommodityId(Long commodityId, Long userId);

    /**
     * 金币是否可领
     * @param goodsId 商品id
     * @param userId 用户id
     * @return true-可领,false-不可领
     */
    Boolean isAvailableGold(Long goodsId, Long userId);

    /**
     * 浏览商品
     * @param browseCommodityParam 请求参数
     * @return
     */
    Boolean getRewardByBrowse(BrowseCommodityParam browseCommodityParam);

}
