package com.bxm.fossicker.commodity.service;

import com.bxm.fossicker.commodity.model.dto.*;
import com.bxm.fossicker.commodity.model.param.*;

import java.util.List;

/**
 * 商品信息服务
 *
 * @author donghy
 */
public interface CommodityInfoService {

    /**
     * 获取商品详情
     * @param param 请求参数
     * @return 商品详情
     */
    CommodityDetailDTO getCommodityDetail(CommodityDetailParam param);

    /**
     * 获取商品详情 -  官方指定查询商品详情方法之一
     * 改方法通过设置参数，调用{@link this#getCommodityDetailWithResultCode 而来}
     *
     * @param param 查询定义，根据实际需求进行设置
     * @return 商品详情，如果查询参数中相关设置为false则会不存在对应数据
     */
    CommodityDetailDTO getCommodityDetail(CommodityDetailQueryParam param);

    /**
     * 根据查询参数，获取商品信息 ---- 官方指定查询商品详情方法之一
     * 如果获取失败或者校验失败会返回错误码
     * 根据错误码针对不同的业务进行处理
     *
     * @param param 请求参数
     * @return 商品详情 以及错误信息
     */
    CommodityDetailResult getCommodityDetailWithResultCode(CommodityDetailQueryParam param);

    /**
     * 获取商品列表的基本信息，所有商品列表的信息转换都必须使用这个方法！
     * 和详情不太一样，有一些字段不会被查询
     *
     * 如果后期有一些额外的查询条件，通过在对象中添加参数来控制！不可以额外写代码了！！！
     *
     * 商品失效(佣金为0) -> 返回 commissionValidate = false
     * 库内和区外都没有数据 -> 返回notFound = true
     *
     * 如果 isLocalOnly 为true，则只查询库内，
     * 如果库内为空或者下架状态，则返回 notFound = true
     *
     * 改方法通过设置参数，调用{@link this#getCommodityDetailWithResultCode 而来}
     * @param param param
     * @return 商品信息
     */
    CommodityListItemResult getCommodityListItemBaseInfo(CommodityDetailQueryParam param);

    /**
     * 浏览商品
     *
     * @param browseCommodityParam 请求参数
     * @return
     */
    Boolean getRewardByBrowse(BrowseCommodityParam browseCommodityParam);

    /**
     * 浏览商品-h5
     *
     * @param browseCommodityParam 请求参数
     * @return
     */
    Boolean getRewardByBrowseForH5(H5BrowseCommodityParam browseCommodityParam);

    /**
     * 获取商品图文详情
     *
     * @param commodityId 商品id
     * @return 图文详情
     */
    List<CommodityDetailInfoDTO> getCommodityDetailPic(Long commodityId);

    /**
     * 创建淘口令
     *
     * @param url            优惠券url
     * @param imgUrl         商品头图url
     * @param commodityTitle 商品标题
     * @return 淘口令
     */
    String createTaoWord(String url, String imgUrl, String commodityTitle);


    /**
     * 获取H5商品详情
     *
     * @param commodityId 商品id
     * @param shareUserId 分享者用户id
     * @param relationId  渠道id
     * @return 商品详情
     */
    H5CommodityDetailDTO getH5CommodityDetailDTO(Long commodityId, Long shareUserId, String relationId);

    /**
     * 获取H5广告部投放落地页商品详情
     *
     * @param commodityId 商品id
     * @param bxmId       变现猫id
     * @return 商品详情
     */
    H5CommodityDetailDTO getH5CommodityDetailDTOForAdvert(Long commodityId, String bxmId);



}
