package com.bxm.fossicker.commodity.service;

import com.bxm.fossicker.commodity.model.dto.CommoditySearchDTO;
import com.bxm.fossicker.commodity.model.param.*;
import com.bxm.fossicker.commodity.model.vo.CategoryCommodityListItem;
import com.bxm.fossicker.commodity.model.vo.BaseCommodityListItem;
import com.bxm.fossicker.commodity.model.vo.PoolCommodityListItem;
import com.bxm.fossicker.vo.PageWarper;

import java.util.List;

/**
 * @Author: pf.w
 * @Date: 2019/7/8 16:41
 */

public interface CommodityListService {

    /**
     * 商品信息列表（根据分类获取商品列表信息）
     * @param param param
     * @return 商品信息列表
     */
    List<CategoryCommodityListItem> goodsListByLabel(GoodsListRequestParam param);

    /**
     * 大淘客二级分类搜索
     * @param param param
     * @return 分类搜索商品列表
     */
    List<CategoryCommodityListItem> goodsListSearchForSubCid(GoodsSearchParam param);

    /**
     * 获取新人零元购商品列表
     * @param userId userId
     * @return 新人零元购商品列表
     */
    List<CategoryCommodityListItem> noviceZeroCommodityList(Long userId);

    /**
     * 可拓展商品列表
     * @param param param
     * @return 可拓展商品列表
     */
    List<PoolCommodityListItem> extendGoodsList(ExtendGoodsListParam param);

    /**
     * 获取分类列表
     * @param param 请求参数
     * @return 分类列表
     */
    List<CategoryCommodityListItem> categoryCommodityList(GoodsListRequestParam param);

    /**
     * 根据投放区域获取分类列表
     * @param param 请求参数
     * @return 分类列表
     */
    List<CategoryCommodityListItem> categoryCommodityListByPosition(GoodsListByPositionParam param);

    /**
     * 获取商品池中的商品列表数据
     * @param poolId poolId
     * @param userId userId
     * @param isVip isVip
     * @return 商品池中的商品列表数据
     */
    List<PoolCommodityListItem> poolCommodityList(Long poolId, Long userId, boolean isVip);

    /**
     * 获取相关推荐商品
     *
     * @param commodityId 商品id
     * @param userId      用户id
     * @return 相关推荐商品list
     */
    List<BaseCommodityListItem> getRecommendCommodity(Long commodityId, Long userId);

    /**
     * 获取猜你喜欢数据
     * @param guessCommodityQueryParam 猜你喜欢商品请求参数
     * @return 商品数据
     */
    PageWarper<CommoditySearchDTO> getGuessLike(GuessCommodityQueryParam guessCommodityQueryParam);

}
