package com.bxm.fossicker.commodity.service;

import com.bxm.fossicker.commodity.model.vo.SearchLog;

import java.util.List;

/**
 * @Author: pf.w
 * @Date: 2019/6/27 17:41
 */
public interface CommoditySearchLogService {

    /**
     * 保存搜索记录
     * @param searchLog
     * @return
     */
    boolean saveSearchLog(SearchLog searchLog);

    /**
     * 删除个人搜索记录
     * @param userId
     * @return
     */
    boolean deleteSearchLog(Long userId);

    /**
     * 获取个人搜索记录
     * @param userId
     * @return
     */
    List<String> getSearchLogByUserId(Long userId);

    /**
     * 调用第三方 “轻淘客”热搜接口，获取“大家都在搜”列表
     * @return
     */
    List<String> getHotSearchLog();
}
