package com.bxm.fossicker.commodity.service;

import com.bxm.fossicker.commodity.model.dto.CommodityPageInfo;
import com.bxm.fossicker.commodity.model.dto.CommoditySearchDTO;
import com.bxm.fossicker.commodity.model.param.ClipboardQueryParam;
import com.bxm.fossicker.commodity.model.param.CommoditySearchParam;

/**
 * 商品搜索相关接口
 * @Author: Gonzo
 * @date  2020-03-02 16:14
 * @since 1.6.0
 */
public interface CommoditySearchService {

    /**
     * 搜索商品列表
     * @param commoditySearchParam 搜索
     * @return 商品列表
     */
    CommodityPageInfo<CommoditySearchDTO> getCommodityListByName(CommoditySearchParam commoditySearchParam);

    /**
     * 获取粘贴板数据信息
     *
     * @param clipboardQueryParam 查询参数
     * @return 商品信息
     */
    CommoditySearchDTO getClipboardCommodity(ClipboardQueryParam clipboardQueryParam);
}
