package com.bxm.fossicker.commodity.service;

import com.bxm.fossicker.commodity.model.dto.DtkPageInfo;
import com.bxm.fossicker.commodity.model.dto.InexpensiveCommodityDTO;
import com.bxm.fossicker.commodity.model.dto.SecCommodityPage;
import com.bxm.fossicker.commodity.model.dto.SecCommodityTimeDTO;
import com.bxm.fossicker.commodity.model.dto.SecKillCommodityDTO;
import com.bxm.fossicker.commodity.model.dto.SecKillCommodityIndexListDTO;
import com.bxm.fossicker.commodity.model.param.InexpensiveCommodityParam;
import com.bxm.fossicker.commodity.model.param.QuerySecKillCommodityParam;
import com.bxm.fossicker.commodity.model.param.RemindCommodityParam;

import java.util.List;

/**
 * 限时秒杀服务
 * @author donghy
 */
public interface SecKillCommodityService {


    /**
     * 获取秒杀商品-供首页使用
     * @param userId 用户id
     * @return 限时秒杀首页展示list实体
     */
    SecKillCommodityIndexListDTO getSecKillCommodityForIndex(Long userId);

    /**
     * 获取限时秒杀时间列表
     * @return 限时秒杀时间列表
     */
    List<SecCommodityTimeDTO> getSecTimeList();

    /**
     * 获取限时秒杀商品列表-淘抢购
     *
     * @param secKillCommodityParam 请求参数
     * @return
     */
    SecCommodityPage<SecKillCommodityDTO> getSecKillCommodityList(QuerySecKillCommodityParam secKillCommodityParam);


    /**
     * 获取聚划算商品列表
     * @param inexpensiveCommodityParam 请求参数
     * @return 聚划算商品列表
     */
    DtkPageInfo<InexpensiveCommodityDTO> getJuCommodity(InexpensiveCommodityParam inexpensiveCommodityParam);

    /**
     * 记录商品提醒
     * @param remindCommodityParam 查询参数
     * @return
     */
    Boolean remindCommodity(RemindCommodityParam remindCommodityParam);

    /**
     * 获取商品提醒状态
     * @param goodsId 商品id
     * @param userId 用户id
     * @return
     */
    int getRemindCommodityStatus(Long goodsId, Long userId);
}
