package com.bxm.fossicker.commodity.service;

import com.bxm.fossicker.commodity.model.param.ChoicenessListParam;
import com.bxm.fossicker.commodity.model.param.UserIdParam;
import com.bxm.fossicker.commodity.model.vo.VipChoicenessCommodityListVO;
import com.bxm.fossicker.commodity.model.vo.VipZeroCommodityBriefListVO;
import com.bxm.fossicker.commodity.model.vo.VipZeroCommodityListVO;
import com.bxm.fossicker.commodity.model.vo.VipZeroPurchaseInfo;

import java.util.List;

/**
 * vip 商品相关service
 * @Author: Gonzo
 * @Date 2020-02-29 21:43
 * @since 1.6.0
 */
public interface VipCommodityService {

    /**
     * 获取会员0元购商品简略列表（会员中心页面使用）
     * @param param param
     * @param isPublicRequest 是否是公开请求
     * @return 会员0元购商品简略列表
     */
    List<VipZeroCommodityBriefListVO> zeroBriefList(UserIdParam param, boolean isPublicRequest);

    /**
     * 获取会员0元购商品列表
     * @param param param
     * @param isPublicRequest 是否是公开请求
     * @return 会员0元购商品列表
     */
    List<VipZeroCommodityListVO> zeroList(UserIdParam param, boolean isPublicRequest);

    /**
     * 获取会员0元购轮播信息
     * @return 会员0元购轮播信息
     */
    List<VipZeroPurchaseInfo> vipZeroPurchaseInfos();

    /**
     * 获取会员精选商品列表
     * @param param param
     * @return 会员精选商品列表
     */
    List<VipChoicenessCommodityListVO> choicenessList(ChoicenessListParam param);

}
