package com.bxm.fossicker.commodity.service.commodity.info;

import com.bxm.fossicker.commodity.model.dto.CommodityInfoDTO;
import com.bxm.fossicker.commodity.model.param.GetCommodityDetailParam;

import java.util.List;

/**
 * @author Gonzo
 * @date 2019-09-27 16:06
 */
public interface CommodityInfoSourceProxyService extends CommodityInfoSourceService {

    /**
     * 获取商品详情
     * 不推荐使用
     * 新接口{@link #getCommodityDetail(GetCommodityDetailParam)}
     * @param commodityId 商品id
     * @return
     * @deprecated
     */
    CommodityInfoDTO getCommodityDetail(Long commodityId);

    /**
     * 获取本地库的商品详情
     * 不推荐使用
     * 新接口{@link #getLocalCommodity(GetCommodityDetailParam)}
     * @param commodityId 商品id
     * @return 商品详情
     * @deprecated
     */
    CommodityInfoDTO getLocalCommodity(Long commodityId);

    /**
     * 获取本地库的商品详情
     * @param param 请求参数
     * @return 商品详情
     */
    CommodityInfoDTO getLocalCommodity(GetCommodityDetailParam param);

    /**
     * 获取三方数据的商品详情
     * @param param 请求参数
     * @return 商品详情
     */
    CommodityInfoDTO getThirdpartyCommodity(GetCommodityDetailParam param);

    /**
     * 数据预热
     * 异步调用
     * @param commodityIds 商品id
     */
    void preheatCommodityInfo(List<Long> commodityIds);

}
