package com.bxm.fossicker.commodity.service.commodity.info.source;

import com.bxm.fossicker.commodity.common.enums.ShopTypeEnum;
import com.bxm.fossicker.commodity.model.dto.CommodityDetailInfoDTO;
import com.bxm.fossicker.commodity.model.dto.CommodityInfoDTO;
import com.bxm.fossicker.commodity.model.param.GetCommodityDetailParam;
import com.bxm.fossicker.commodity.service.BlackCommodityService;
import com.bxm.fossicker.commodity.service.commodity.info.CommodityInfoSourceStrategy;
import com.bxm.newidea.component.redis.RedisHashMapAdapter;
import com.bxm.newidea.component.redis.RedisStringAdapter;
import com.google.common.collect.Lists;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;

import java.util.Collections;
import java.util.List;
import java.util.Objects;

/**
 * @author Gonzo
 * @date 2019-09-26 19:33
 */
@Slf4j
public abstract class AbstractCommodityInfoSourceStrategy implements CommodityInfoSourceStrategy {

    @Autowired
    protected BlackCommodityService blackCommodityService;

    @Autowired
    protected RedisHashMapAdapter redisHashMapAdapter;

    @Autowired
    protected RedisStringAdapter redisStringAdapter;


    @Override
    public CommodityInfoDTO getCommodityDetail(GetCommodityDetailParam param) {

        if (Objects.isNull(param) || Objects.isNull(param.getCommodityId())) {
            log.error("商品id为null，获取详细信息失败");
            return null;
        }

        CommodityInfoDTO infoDTO = doGetCommodityDetail(param);

        // 如果图片链接不存在 用首图
        setImgUrlListFromFirstPicIfNecessary(infoDTO);

        return infoDTO;
    }

    @Override
    public List<CommodityDetailInfoDTO> getCommodityDetailInfo(Long commodityId) {

        if (Objects.isNull(commodityId)) {
            log.error("商品id为null，获取图文信息失败");
            return Lists.newArrayList();
        }

        return doGetCommodityDetailInfo(commodityId);
    }

    /**
     * 根据shopUrl判断商铺类型，截取对应字段,B-天猫,C-淘宝
     * @param type B-天猫,C-淘宝
     * @return
     */
    protected Integer getShopTypeFromTypeCode(String type) {

        if (StringUtils.isBlank(type)) {
            return ShopTypeEnum.DEFAULT.getType();
        }

        if (type.contains(ShopTypeEnum.TAOBAO.getDescription())) {

            return ShopTypeEnum.TAOBAO.getType();
        }

        if (type.contains(ShopTypeEnum.TMALL.getDescription())) {
            return ShopTypeEnum.TMALL.getType();
        }

        return ShopTypeEnum.DEFAULT.getType();
    }

    protected void setImgUrlListFromFirstPicIfNecessary(CommodityInfoDTO infoDTO) {

        if (Objects.isNull(infoDTO)) {
            return;
        }

        if (CollectionUtils.isEmpty(infoDTO.getImgUrlList()) && StringUtils.isNotBlank(infoDTO.getMainPic())) {

            infoDTO.setImgUrlList(Collections.singletonList(infoDTO.getMainPic()));
        }
    }


    /**
     * 获取商品详情
     * @param param
     * @return
     */
    protected abstract CommodityInfoDTO doGetCommodityDetail(GetCommodityDetailParam param);

    /**
     * 获取图文详情
     * @param commodityId
     * @return
     */
    protected abstract List<CommodityDetailInfoDTO> doGetCommodityDetailInfo(Long commodityId);


}
