package com.bxm.fossicker.commodity.service.commodity.list;

import com.bxm.fossicker.commodity.model.param.CommodityListParam;
import com.bxm.fossicker.commodity.model.vo.BaseCommodityListItem;

import java.util.List;

/**
 * 商品列表抽象接口
 * T 列表元素对象
 * P 请求列表参数
 * @Author: Gonzo
 * @date  2020-03-03 18:32
 * @since 1.6.0
 */
public interface CommodityListService<T extends BaseCommodityListItem, P extends CommodityListParam> {

    /**
     * 请求不同的商品列表
     * @param p 请求列表参数
     * @return 列表数据
     */
    List<T> commodityList(P p);

    /**
     * 支持的参数类型
     * @return 支持的参数类型
     */
    Class<P> support();
}
