package com.bxm.fossicker.commodity.service.commodity.list;

import com.bxm.fossicker.commodity.model.param.CommodityListParam;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import lombok.extern.slf4j.Slf4j;
import org.springframework.context.ApplicationContext;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.context.event.EventListener;
import org.springframework.stereotype.Service;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;

@Service
@Slf4j
public class CommodityListServiceProxy {

    private Map<Class<CommodityListParam>, CommodityListService> serviceMap = Maps.newHashMap();

    public <T> List<T>  getCommodityList(CommodityListParam param) {
        CommodityListService service = getService(param);
        if (Objects.isNull(service)) {
            log.warn("类型: {} 不存在对应的商品列表service", param.getClass());
            return Lists.newArrayList();
        }
        return service.commodityList(param);
    }

    protected CommodityListService getService(CommodityListParam param) {
        return serviceMap.get(param.getClass());
    }

    @EventListener(ContextRefreshedEvent.class)
    public void onApplicationStartedEvent(ContextRefreshedEvent event) {
        ApplicationContext applicationContext = event.getApplicationContext();
        Collection<CommodityListService> commodityListServices = applicationContext.getBeansOfType(CommodityListService.class)
                .values();

        commodityListServices.forEach(p -> {
            serviceMap.put(p.support(), p);
        });
    }


}
