package com.bxm.fossicker.commodity.service.commodity.list.impl;

import com.bxm.fossicker.commodity.model.dto.CommodityListItemResult;
import com.bxm.fossicker.commodity.model.dto.CommoditySearchDTO;
import com.bxm.fossicker.commodity.model.dto.WySearchCommodityInfoDTO;
import com.bxm.fossicker.commodity.model.param.CommodityDetailQueryParam;
import com.bxm.fossicker.commodity.model.param.GuessLikeListParam;
import com.bxm.fossicker.commodity.model.param.WySearchCommodityInfoParam;
import com.bxm.fossicker.commodity.model.vo.BaseCommodityListItem;
import com.bxm.fossicker.commodity.service.commodity.list.AbstractCommodityListService;
import com.bxm.fossicker.commodity.service.externel.WyCommodityService;
import com.bxm.fossicker.vo.PageWarper;
import com.google.common.collect.Lists;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

/**
 * 猜你喜欢列表
 * @Author: Gonzo
 * @date  2020-03-03 18:36
 * @since 1.6.0
 */
@Service
public class GuessLikeCommodityListService extends AbstractCommodityListService<BaseCommodityListItem,
        GuessLikeListParam> {

    @Autowired
    private WyCommodityService wyCommodityService;

    @Override
    protected List<BaseCommodityListItem> doGetCommodityList(GuessLikeListParam param) {
        PageWarper<CommoditySearchDTO> resultPage = new PageWarper<>();
        resultPage.setPageNum(param.getGuessCommodityQueryParam().getPageNum());
        resultPage.setPageSize(param.getGuessCommodityQueryParam().getPageSize());

        List<WySearchCommodityInfoDTO> wyCommodityList = wyCommodityService.guessLike(param.getGuessCommodityQueryParam());
        if (CollectionUtils.isEmpty(wyCommodityList)) {
            return Lists.newArrayList();
        }

        return wyCommodityList.stream()
                .map(p -> {
                    CommodityDetailQueryParam queryParam = initCommodityDetailQueryParam(param, p.getItemId());

                    // 需要只查询本地信息
                    queryParam.setQueryLocalOnly(true);

                    CommodityListItemResult result = commodityListItemBaseInfo(queryParam);

                    // 如果本地获取失败
                    if (!checkCommodityListBaseItemSuccess(result)) {
                        // 根据维易信息进行封装
                        queryParam.setWySearchCommodityInfoParam(WySearchCommodityInfoParam.builder()
                                .wyInfo(p)
                                // 猜你喜欢的转换
                                .convertType((byte) 2)
                                .build());
                        result =  commodityListItemBaseInfo(queryParam);

                        // 如果还校验不通过，就过滤
                        if (!checkCommodityListBaseItemSuccess(result)) {
                            return null;
                        }
                    }

                    return result.getListItem();
                })
                .filter(Objects::nonNull)
                .collect(Collectors.toList());
    }

    @Override
    protected String description() {
        return "猜你喜欢列表";
    }

    @Override
    public Class<GuessLikeListParam> support() {
        return GuessLikeListParam.class;
    }
}
